% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mcgraph.R
\name{mcg.accuracy}
\alias{mcg.accuracy}
\title{prediction quality of a predicted graph in comparison to a known true one.}
\usage{
mcg.accuracy(g.true, g.pred)
}
\arguments{
\item{g.true}{mcg.graph object or adjacency matrix of a the true graph.}

\item{g.pred}{mcg.graph object or adjacency matrix of a predicted graph.}
}
\value{
returns list object with various accuracy measures, such as Sens(itivity), Spec(ificity), Acc(uracy), balanced classification rate (BCR), F1 measure and Mathhews correlaition coefficient (MCC).
}
\description{
The function `mcg.accuracy` measures the prediction
 quality of a predicted graph in comparison to a known true one.
 The graph comparisons are done on the basis of undirected graphs only.
 Directed graphs are converted to undirected internally.
}
\examples{
ang=mcg.angie(nodes=12,edges=18)
data=mcg.graph2data(ang)
pred=mcg.ct(t(data),rs=0.1)
round(unlist(mcg.accuracy(ang,pred)),2)
pred=mcg.lvs(t(data))
round(unlist(mcg.accuracy(ang,pred)),2)
pred=mcg.rpart(t(data))
round(unlist(mcg.accuracy(ang,pred)),2)
}
\author{
: Detlef Groth <dgroth@uni-potsdam.de>
}
