% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mcgraph.R
\name{mcg.new}
\alias{mcg.new}
\title{Create a new `mcgraph` object}
\usage{
mcg.new(A, type = "custom")
}
\arguments{
\item{A}{Input adjacency matrix.}

\item{type}{Custom type name for the graph. Default: 'custom'}
}
\value{
A mcgraph object for the given adjacency matrix.
}
\description{
Based on a given adjacency matrix a new mcgraph object is created.
}
\details{
The function mcg.new generates for the given adjacency matrix a mcgraph object.
     If the adjacency matrix is has symmetric upper and lower triangles, the graph is undirected,
     otherwise the function will return a directed graph.
}
\examples{
\dontrun{
if(interactive()){
 G=matrix(0,nrow=6,ncol=6)
 rownames(G)=colnames(G)=LETTERS[1:6]
 G['A','C']=1
 G['B','C']=1
 G['C','D']=1
 G['D','E']=1
 G['D','F']=1
 G['E','F']=1
 G=mcg.new(G,type="test")
 plot(G)
 }
}
}
