% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mcgraph.R
\name{mcg.hubs}
\alias{mcg.hubs}
\title{mcg.hubs creates separate cluster of nodes with a central hub node}
\usage{
mcg.hubs(nodes = 8, hubs = 2)
}
\arguments{
\item{nodes}{Number of nodes in the graph.}

\item{hubs}{Number of components each having one hub node.}
}
\value{
Graph of class mcgraph with adjacency matrix for an undirected graph.
}
\description{
`mcg.hubs` creates multiple graph components each having a central hub node.
}
\details{
This function creates a graph with one to many components where every component has a central hub connected to all other nodes of the component.
}
\examples{
hubs=mcg.hubs(nodes=21,hubs=3)
plot(hubs,vertex.color=rainbow(21))
}
\author{
Detlef Groth <dgroth@uni-potsdam.de>
}
