% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mcgraph.R
\name{mcg.graph2data}
\alias{mcg.graph2data}
\title{mcg.graph2data create simulated data}
\usage{
mcg.graph2data(
  A,
  n = 200,
  iter = 30,
  val = 100,
  sd = 2,
  prop = 0.05,
  noise = 1,
  init = NULL,
  code = "C++"
)
}
\arguments{
\item{A}{either a adjacency matrix from a directed graph or a mcgraph object created with `mcg.u2d`.}

\item{n}{number of samples for which data should be generated.}

\item{iter}{Number of iterations done for each node to generate the data. Default: 30}

\item{val}{initial value to be used to for nodes. Default: 100}

\item{sd}{standard deviation to be used at initialisation and in each iteration to create new values for each node. Default: 2}

\item{prop}{amount of influence of source node for input node per iteration, default: 0.05}

\item{noise}{amount of scatter added in each iteration to the computed value. It is the sd of a rnorm call with mean of zero. Default: 1}

\item{init}{initialization values, matrix should match the A adjacency matrix with rows and the requested number of samples as columns, if NULL start values are choosen randomly default: NULL}

\item{code}{should the R or the C++ version be used, default: C++}
}
\value{
data matrix where rows are the node names and columns are the values for the simulated data. Data are not normalized to allow inspection of the data influence. Before further usage data should be scaled.
}
\description{
`mcg.graph2data` create simulated data from a directed graph
}
\details{
This function takes a input either a adjacency matrix from a directed graph, or a directed mcgraph created with the mcg.u2d function.
The function creates simulated data for the given graph using a Monte Carlo simulation.
With the defaults the function will create data where the absolute correlations
are on average around 0.5, To increase or decrease those average correlations,
increase  or decrease the number of iterations using the 'iter' argument.
}
\examples{
anu <- mcg.angie(nodes=12, edges=18)
and <- mcg.u2d(anu, input=2, negative=0.2)
and.data <- mcg.graph2data(and, n=200)
t1 <- Sys.time()
and.data <- mcg.graph2data(and, n=200, code="R")
print(Sys.time() - t1)
t1 <- Sys.time()
and.data <- mcg.graph2data(and, n=200, code="C++")
print(Sys.time() - t1)
round(cor(t(and.data)), 2)
plot(and)
# directed graph example
G=matrix(0,nrow=7,ncol=7)
rownames(G)=colnames(G)=LETTERS[1:7]
G['A','C']=1
G['B','C']=1
G['C','D']=1
G['D','E']=1
G['D','F']=1
G['E','F']=1
G['G','A']=-1
G
g=mcg.new(G)
plot(g,layout='sam')
data=mcg.graph2data(g)
print(round(cor(data),1))
# weighted graph
G['A','C']=1.6
g=mcg.new(G)
plot(g,layout='sam')
data=mcg.graph2data(g)
print(round(cor(data),1))
}
\author{
Detlef Groth <email: dgroth@uni-potsdam.de>, Masiar Novine <email: masiar.novine@gmail.com>
}
\keyword{simulation}
