% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mcgraph.R
\name{mcg.glmnet}
\alias{mcg.glmnet}
\title{mcg.glmnet - create new graphs from data using Ridge, Elastic Net or Lasso regression}
\usage{
mcg.glmnet(x, type = "lasso", rs = 0.04, alpha = 1)
}
\arguments{
\item{x}{data frame or matrix with numerical daattr(Gswiss,"r.squared"),3ta.}

\item{type}{custom type name for the graph, Default: 'lasso'}

\item{rs}{threshold for the R-square value. Default: 0.04}

\item{alpha}{elasticnet mixing paramater with 0 we have Ridge regression, with 1 with have Lasso, in between we have elasticnet, default: 1}
}
\value{
an mcgraph object for the data, or a adjacency matrix or list depending on the keep argument,
     in the adjacency matrix a value of minus indicate negative associations
     between the nodes, a value of +1 positive associations, additional attributes such as 'r.squared' values and 'std.coef'
     standardized coefficients are added as well
}
\description{
The function mcg.glmnet - creates a new mcgraph object from
       given data using Ridge, Elastic Net or Lasso regressions. Nodes will be connected to other nodes if their coefficient is not zero or their R-square value
       exceeds a certain threshold.
}
\examples{
data(swiss)
Gswiss=mcg.glmnet(swiss,rs=0.1)
plot(Gswiss,main="Predicted Graph",layout='star')
}
\author{
Detlef Groth, University of Potsdam
}
