% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mcgraph.R
\name{mcg.angie}
\alias{mcg.angie}
\title{mcg.angie creates small world like random graphs within one component}
\usage{
mcg.angie(nodes = 26, edges = 52)
}
\arguments{
\item{nodes}{Number of nodes in the graph. Default: 26}

\item{edges}{Number of edges in the graph. Default: 40}
}
\value{
Graph of class mcgraph with adjacency matrix for an undirected graph.
}
\description{
`mcg.angie` creates a single component graph with properties close to small world graphs.
}
\details{
This function creates a random graph with a given number of nodes and a given number of edges by first building a tree like graph structure,
where nodes are stepwiese added to existing nodes in the graph. In the second step edges will be added which randomly connect two nodes in the graph.
}
\examples{
angie=mcg.angie(nodes=26,edges=40)
plot(angie,vertex.color=rainbow(26))
}
\references{
Fritz, Makejeva, Staub, Groth AA 2019.
}
\author{
Detlef Groth <dgroth@uni-potsdam.de>
}
