% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mcgraph.R
\name{mcg.timeit}
\alias{mcg.timeit}
\title{Evaluate the time required for a given R expression}
\usage{
mcg.timeit(expr, n = 5)
}
\arguments{
\item{expr}{a valid R expression}

\item{n}{how often should the expression be executed, default: 5}
}
\value{
a vector with n values in seconds the time required to evaluate the expression
}
\description{
The function can be used to measure the required computation time for a given R expression
  which is executed one or more times.
}
\examples{
data(iris)
mcg.timeit(expression(hclust(dist(iris[,1:4]))))
data(swiss)
mcg.timeit(expression(mcg.lvs(swiss, rs=0.1, output='mcgraph')))
mean(mcg.timeit(expression(mcg.lvs(swiss, rs=0.1, output='mcgraph'))))
mean(mcg.timeit(expression(mcg.lvs(swiss, rs=0.1, output='mcgraph',code="R"))))
}
\author{
Detlef Groth <email: dgroth@uni-potsdam.de>
}
