% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mcgraph.R
\name{mcg.barabasi}
\alias{mcg.barabasi}
\title{mcg.barabasi creates a scale free Barabasi-Albert graph}
\usage{
mcg.barabasi(nodes = 26, m = 1)
}
\arguments{
\item{nodes}{Number of nodes in the graph. Default: 26}

\item{m}{Number of edges to connect each added node to the graph. Default: 1}
}
\value{
Graph of class mcgraph with adjacency matrix for an undirected graph.
}
\description{
`mcg.barabasi` simplified mode to create a graph based on the Barabasi-Allbert algorithm
}
\details{
This function create a random graph whith a given number of nodes.
Nodes are added subsequently connected by  defined number of edges to nodes added before in the graph.
}
\examples{
bara=mcg.barabasi(nodes=20, m=1)
plot(bara,vertex.color=rainbow(20))
}
\references{
Barabasi, A.-L. and Albert R. 1999. Emergence of scaling in random networks _Science_, 286 509-512

Csardi G, Nepusz T: The igraph software package for complex network research, InterJournal, Complex Systems 1695. 2006. http://igraph.org
}
\author{
Detlef Groth <dgroth@uni-potsdam.de>
}
