require("mcgraph")
source("../Comparative_analysis_of_Monte_Carlo_data/mcg.g2d.wrapper.R")
res.raw <- readRDS("../Comparative_analysis_of_Monte_Carlo_data/results/results_2022-22-01-15:22:53")
res <- res.raw$data
pal <- hcl.colors(10, palette="Spectral")[c(3, 9, 2)]
# Subset of all results for mcg.lvs, but just based on PR-AUC. mcg.lvs had generally good scores, don't include high-dimensional networks
colkeys <- which(colnames(res) %in% c("pkg", "nw.type", "classifier", "PR.AUC", "nodes", "edges", "cluster", "hub", "seed"))
clu_raw <- res[which(res$pkg == "mcgraph" & res$classifier == "mcg.lvs" & res$nodes != 400 &
                     res$PR.AUC == min(res[which(res$pkg == "mcgraph" & res$classifier == "mcg.lvs" & res$nodes != 400),
                     which(colnames(res) == "PR.AUC")])), colkeys]
G <- mcg.g2d.wrapper(nodes=clu_raw$nodes, graph="mcg.cluster", edges=clu_raw$edges,
    cluster=clu_raw$cluster, seed=clu_raw$seed)

# Plot the model cluster network used
setwd("../figure")
pdf("Figure4.pdf", height=7, width=7)
par(mar=c(0,0,3,0))
compIDs <- mcg.components(G$theta)
compIDs[compIDs == 1] <- pal[1]
compIDs[compIDs == 2] <- pal[2]
compIDs[compIDs == 3] <- pal[3]
lay <- mcg.layout.frg(G$theta, L=10, W=10, temp_prop=0.1, force_prop=0.4, quench_prop=0.92)
plot(G$theta, vertex.size=.4, show.labels=TRUE, vertex.color=compIDs, layout=lay, label.size=0.5, edge.width=1.2, label.pos=NULL, main="Cluster network with three components")
dev.off()
setwd("../Analysis_of_parameters_of_the_Monte_Carlo_algorithm")
